#include "arm.h"
#include <math.h>

Arm::Arm(Object *parent, Direction *dir, bool *grab, bool *punch) : Roster(parent)
{
	this->dir = dir;
	this->grab = grab;
	this->punch = punch;
	cur_ext = 1.0;
	ext_dir = 0.0;
	mode = 0;

	top = new Stretch(this);
	bottom = new Stretch(this);
	middle = new Stretch(this);
	held = new Roster(this);

	top->assignLinkGroup(1);
	bottom->assignLinkGroup(2);
	middle->assignLinkGroup(3);

	int i;
	for(i = 0; i < MAXLEVELS; i++) {
		normal_levels[i] = false;
		punch_levels[i] = true;
	}
	punch_levels[0] = false;
	punch_levels[5] = false;
	punch_levels[3] = false;
	punched = false;
	threw = false;
	throwing = false;
	power = 0.0f;
	charging = false;
}

/*  LEVELS

0 - fist
5 - monster
6 - something monster is holding

*/

#include <container.h>
#include <system.h>

void Arm::grasp() {		
	Atom *b;
	float lbp = 0.0f;
	float ubp = 99.0f;
	float k = 0.4f;
	float dx, dy;
	Container *c;
	Link *l;
	int grabbed = 0;
	const int max_grab = 10;
	bool got_close = false;

	int xo, yo;
	for(xo = -2; xo <= 2; xo++) {
		for(yo = -2; yo <= 2; yo++) {
			c = &(fist->system->containers[fist->cx + xo][fist->cy + yo]);
			if(c->stamp == fist->system->tick) {
				b = c->first;

				while(b != NULL && grabbed < max_grab) {
					if(b->numlinks > 1 && b->object != this && b->object != parent && b->object->parent != parent && b->mass < 10) {
						dx = fist->x - b->x;
						dy = fist->y - b->y;
						if(dx * dx + dy * dy < 300) {
							if(!got_close && dx * dx + dy * dy < 70) got_close = true;
							Atom *a;
							atoms.begin();
							while(a = atoms.get()) {
								l = new Link(a, b, -1.0f, lbp, ubp, k);
								//b->level = 6;
								//b->levels[5] = false;
								l->draw = false;
								l->rigidity = 5;
								held->addLink(l);
								held->atoms.add(b);
								//held->addAtom(b);
							}
							grabbed++;
							if(grabbed >= max_grab) {
								xo = yo = 999;
							}
						}
					}							

					b = b->next;
				}
			}
		}
	}

	if(!got_close) {
		drop();
		return;
	}

	if(held->atoms.length() == 0) return;

	held->atoms.begin();
	Roster *sys = held->atoms.get()->system->roster;
	sys->links.begin();
	while(l = sys->links.get()) {
		if(held->atoms.contains(l->a) && held->atoms.contains(l->b)) {
			l->lbp = 0.0;
			l->ubp = 2.0;
		}
		//else if(held->atoms.contains(l->a) || held->atoms.contains(l->b)) {
		//	l->lbp = 0;
		//	l->ubp = 2.0;
		//}
	}
}

void Arm::drop() {
	Link *l;

	held->links.begin();
	while(l = held->links.get()) {
		delete l;
		held->links.begin();
	}

	while(held->atoms.length() > 0) {
		held->atoms.begin();
		held->atoms.get();
		held->atoms.removeCurrent();
	}
	
	charging = false;
	power = 0.0f;
}

void Arm::chuck() {
	/*
	Atom *a;
	float mult = 4.0f * (1.0f / held->atoms.length()) * (1.0f / held->atoms.length());;
	held->atoms.begin();
	while(a = held->atoms.get()) {
		a->ox -= 2.0f * dir->dx;
		a->oy -= 2.0f * dir->dy;
		held->atoms.removeCurrent();
		held->atoms.begin();
	}
	*/
	if(held->atoms.length() == 0) return;

	///*
	Link *l;
	held->atoms.begin();
	Roster *sys = held->atoms.get()->system->roster;
	sys->links.begin();
	int count = 0;
	while(l = sys->links.get()) {
		if(held->atoms.contains(l->a)) {
			if(!held->atoms.contains(l->b)) {
				if(count < 10 || count % 4 == 0) {
					held->atoms.add(l->b);
					count++;
				}
			}
		}
		else if(held->atoms.contains(l->b)) {
			if(count < 10 || count % 4 == 0) {
				held->atoms.add(l->a);
				count++;
			}
		}
	}
	//*/

	float force = 3.5f - (held->atoms.length() / 45.0f);
	if(force < 0) force = 0;
	if(power <= 1.0f)
		force *= power;
	else
		force *= (1.0f + (power - 1.0f) * (power - 1.0f));
	power = 0.0f;
	if(power < 0.0f) power = 0.0f;
	float fx = force * dir->dx;
	float fy = force * dir->dy;

	Atom *a;
	held->atoms.begin();
	while(a = held->atoms.get()) {
		a->ox -= fx;
		a->oy -= fy;
	}

	drop();
}

void Arm::stepFunc() {
	const float recharge = 0.02f;
	const float supercharge = 0.003f;
	if(power <= 1.0f - recharge && held->atoms.length() > 0) power += recharge;
	else if(charging && ext_dir == 0.0f) {
		if(power < 2.0f) power += supercharge;
		float retract = power * 0.25f;
		if(retract > 0.10f) retract = 0.10f;
		cur_ext = 1.0f - retract;
	}
	if(!*punch) punched = false;
	if(!*grab) threw = false;
	if(mode == 0) {
		if(*punch && !punched) {
			punched = true;
			mode = 1;
			ext_dir = 0.3;
			Atom *a;
			atoms.begin();
			while(a = atoms.get()) {
				a->level = 3;
				for(int i = 0; i < MAXLEVELS; i++)
					a->levels[i] = punch_levels[i];
			}
		}
		else if(*grab && !charging && !throwing && held->atoms.length() > 0) {
			charging = true;
			//power = 0.0f;
		}
		else if(!threw && !throwing && ((charging && !*grab) || (!charging && *grab && held->atoms.length() == 0))) {
			charging = false;
			mode = 2;
			if(held->atoms.length() != 0) {
				ext_dir = 0.4;
				threw = true;
				throwing = true;
			}
			else
				ext_dir = 0.1;
		}
	}
	if(mode == 3 && !*grab) {
		ext_dir = -0.1;
		grasp();
		mode = 1;
	}

	dir->calc();

	if(ext_dir != 0.0) {
		cur_ext += ext_dir;
		if(cur_ext > 1.0 && mode == 2 && throwing) {
			mode = 4;
			chuck();
			power = 0.0f;
		}
		if(cur_ext > 2.0 && mode == 4 && throwing) {
			mode = 1;
			cur_ext = 2.0;
			ext_dir = -0.2;
		}
		else if(cur_ext > 1.5 && mode == 2 && !throwing) {
			ext_dir = 0.0;
			cur_ext = 1.5;
			mode = 3;
			Link *l;
			held->links.begin();
			while(l = held->links.get()) {
				delete l;
				held->links.begin();
			}
			Atom *a;
			held->atoms.begin();
			while(a = held->atoms.get()) {
				held->atoms.removeCurrent();
				held->atoms.begin();
			}
		}
		else if(cur_ext > 2.0 && (!throwing || punched)) {
			mode = 1;
			ext_dir = -0.2;
		}
		if(cur_ext < 1.0) {
			throwing = false;
			cur_ext = 1.0;
			ext_dir = 0.0;
			if(mode == 1) {
				Atom *a;
				atoms.begin();
				while(a = atoms.get()) {
					a->level = 0;
					for(int i = 0; i < MAXLEVELS; i++)
						a->levels[i] = normal_levels[i];
				}
			}
			mode = 0;
		}
	}

	//float angle = atan(dir->dy / dir->dx);
	if(dir->dy > 0) {
		top->stretch(cur_ext - cur_ext * 0.1 * dir->dy);
		bottom->stretch(cur_ext + cur_ext * dir->dy);
	}
	else {
		bottom->stretch(cur_ext + cur_ext * 0.1 * dir->dy);
		top->stretch(cur_ext - cur_ext * dir->dy);
	}
	middle->stretch(cur_ext);
}

void Arm::addAtom(Atom *a)
{
	Roster::addAtom(a);

	if(a->group == 6)
		fist = a;
}